/**************************************************************************************
 
   Copyright (c) Hilscher GmbH. All Rights Reserved.
 
 **************************************************************************************
 
   Filename:
    $Workfile: ProfibusApm_Public.h $
   Last Modification:
    @version $Id: ProfibusApm_Public.h 45106 2014-04-24 13:15:22Z mark $
   
   Targets:
    Win32/ANSI   : no
    Win32/Unicode: no (define _UNICODE)
    WinCE        : yes
    rcX          : yes
 
   Description:
     
    Profibus Apm
    public
   
   Changes:
 
     Version    Date        Author
        Description
     ----------------------------------------------------------------------------------
        
**************************************************************************************/
#ifndef __PROFIBUS_APM_PUBLIC_H
#define __PROFIBUS_APM_PUBLIC_H


/***************************************************************************************/
/* Profibus Apm public, constants */

#define PROFIBUS_APM_PROCESS_QUEUE_NAME       "APM_QUE"


/***************************************************************************************/
/* Profibus Apm public, types */

typedef __TLR_PACKED_PRE struct PROFIBUS_APM_GLOBAL_STATE_FIELD_Ttag {

  /* bit field to show bus and master main errors */   
  unsigned char bGlobalBits;  
  #define MSK_PROFIBUS_APM_EXT_STA_CTRL_ERR 0x01
  #define MSK_PROFIBUS_APM_EXT_STA_ACLR_ERR 0x02
  #define MSK_PROFIBUS_APM_EXT_STA_NEXC_ERR 0x04
  #define MSK_PROFIBUS_APM_EXT_STA_FATL_ERR 0x08
  #define MSK_PROFIBUS_APM_EXT_STA_NRDY     0x10
  #define MSK_PROFIBUS_APM_EXT_STA_TOUT     0x20


  /* master main states */
  unsigned char   bDPM_state;
  /* USIF_OFFLINE 0x00 */
  /* USIF_STOP    0x40 */
  /* USIF_CLEAR   0x80 */
  /* USIF_OPERATE 0xC0 */
 
  /* location of error and error code */
  __TLR_PACKED_PRE struct
  {
    unsigned char bErr_Rem_Adr; /* 0-125, 255 */
    unsigned char bErr_Event;   
  
  }__TLR_PACKED_POST tError;

  /* counter for the bus error events */
  unsigned short  usBus_Error_Cnt;

  /* counter for  bus timeouts */
  unsigned short  usTime_Out_Cnt;

  /* reserved area */
  unsigned char   abReserved[8];

  /* Bit-Ready, Cfg-Ready and diagnostic display of slave devices */
  unsigned char   abSl_cfg  [16];  /* Slave configuration area */
  unsigned char   abSl_state[16];  /* Slave state information area */
  unsigned char   abSl_diag [16];  /* Slave diagnostic area */
}__TLR_PACKED_POST PROFIBUS_APM_GLOBAL_STATE_FIELD_T;

typedef __TLR_PACKED_PRE struct PROFIBUS_APM_EXT_STATUS_Ttag {
  
  PROFIBUS_APM_GLOBAL_STATE_FIELD_T tGlobStateFiled;
  
}__TLR_PACKED_POST PROFIBUS_APM_EXT_STATUS_T;


/****************************************************************************************
* Profibus APM, command codes  */

/* Start of the Profibus APM packet area 0x3000 - 0x30FF */
#define PROFIBUS_APM_PACKET_COMMAND_START       0x00003000

#define PROFIBUS_APM_CMD_REDUNDANT_MODE_REQ     0x00003000    
#define PROFIBUS_APM_CMD_REDUNDANT_MODE_CNF     0x00003001    

#define PROFIBUS_APM_CMD_REDUNDANT_MODE_IND     0x00003002    
#define PROFIBUS_APM_CMD_REDUNDANT_MODE_RES     0x00003003    

#define PROFIBUS_APM_PACKET_COMMAND_END         0x00003003

/***************************************************************************************/
/* Profibus Apm public, packets */

/* pragma pack */
#ifdef PRAGMA_PACK_ENABLE
#pragma PRAGMA_PACK_1(PROFIBUS_APM_PUBLIC)
#endif

#define PROFIBUS_APM_REDUNDANT_MASTER_ACTIVE          0x00
#define PROFIBUS_APM_REDUNDANT_MASTER_BACKUP          0x01

#define PROFIBUS_APM_REDUNDANT_MODE_PNO               0x00
#define PROFIBUS_APM_REDUNDANT_MODE_HILSCHER          0x02

#define PROFIBUS_APM_REDUNDANT_MONITOR_PRIMARY_ONLY   0x00
#define PROFIBUS_APM_REDUNDANT_MONITOR_BACKUP_PRIMARY 0x04

#define PROFIBUS_APM_REDUNDANT_MASK                   0x07

typedef __TLR_PACKED_PRE struct  PROFIBUS_APM_REDUNDANT_MODE_REQ_Ttag
{
  TLR_UINT8 bRedundantAddr;     /* station address of redundant master */
  TLR_UINT8 bOption;            /* redundant options */
} __TLR_PACKED_POST PROFIBUS_APM_REDUNDANT_MODE_REQ_T;

#define PROFIBUS_APM_REDUNDANT_MODE_REQ_SIZE (sizeof(PROFIBUS_APM_REDUNDANT_MODE_REQ_T))

/* Request-Packet for acknowledged connectionless data transfer */
typedef struct  PROFIBUS_APM_PACKET_REDUNDANT_MODE_REQ_Ttag
{
  TLR_PACKET_HEADER_T tHead;
  PROFIBUS_APM_REDUNDANT_MODE_REQ_T tData;    /* Packet Data Unit */
} PROFIBUS_APM_PACKET_REDUNDANT_MODE_REQ_T;


#define PROFIBUS_APM_REDUNDANT_MODE_CNF_SIZE (0)

/* Request-Packet for acknowledged connectionless data transfer */
typedef struct  PROFIBUS_APM_PACKET_REDUNDANT_MODE_CNF_Ttag
{
  TLR_PACKET_HEADER_T tHead;
} PROFIBUS_APM_PACKET_REDUNDANT_MODE_CNF_T;


typedef __TLR_PACKED_PRE struct  PROFIBUS_APM_REDUNDANT_MODE_IND_Ttag
{
  TLR_BOOLEAN8 fActiveMasterExist;
  TLR_BOOLEAN8 fBackupMasterExist;
} __TLR_PACKED_POST PROFIBUS_APM_REDUNDANT_MODE_IND_T;

#define PROFIBUS_APM_REDUNDANT_MODE_IND_SIZE (sizeof(PROFIBUS_APM_REDUNDANT_MODE_IND_T))

/* Request-Packet for acknowledged connectionless data transfer */
typedef struct  PROFIBUS_APM_PACKET_REDUNDANT_MODE_IND_Ttag
{
  TLR_PACKET_HEADER_T tHead;
  PROFIBUS_APM_REDUNDANT_MODE_IND_T tData;    /* Packet Data Unit */
} PROFIBUS_APM_PACKET_REDUNDANT_MODE_IND_T;

/* field bus specific length and structure for CiR.*/
/*TODO: RCX_VERIFY_MASTER_DATABASE_T can be removed by new rcX V2.0.9.X*/
typedef struct PROFIBUS_APM_VERIFY_MASTER_DATABASE_Ttag
{
  TLR_UINT32  ulMasterSettings;  /* field bus independent changes*/
  TLR_UINT32  ulMasterStatus;  /* field bus specific status*/
  TLR_UINT32  ulReserved[2];
} PROFIBUS_APM_VERIFY_MASTER_DATABASE_T;


#define PROFIBUS_APM_VERIFY_SLAVE_DATABASE_LIST_SIZE sizeof(PROFIBUS_APM_VERIFY_SLAVE_DATABASE_LIST_T)
#define PROFIBUS_APM_CIR_MST_SET_STARTUP       0x00000001
#define PROFIBUS_APM_CIR_MST_SET_WATCHDOG      0x00000002
#define PROFIBUS_APM_CIR_MST_SET_STATUSOFFSET  0x00000004
#define PROFIBUS_APM_CIR_MST_SET_BUSPARAMETER  0x00000008

typedef __TLR_PACKED_PRE struct PROFIBUS_APM_VERIFY_DATABASE_CNF_DATA_Ttag
{
    RCX_VERIFY_SLAVE_DATABASE_LIST_T                tNewSlaves;
    RCX_VERIFY_SLAVE_DATABASE_LIST_T                tDeactivatedSlaves;
    RCX_VERIFY_SLAVE_DATABASE_LIST_T                tChangedSlaves;
    RCX_VERIFY_SLAVE_DATABASE_LIST_T                tUnchangedSlaves;
    RCX_VERIFY_SLAVE_DATABASE_LIST_T                tImpossibleSlaveChanges;
    PROFIBUS_APM_VERIFY_MASTER_DATABASE_T                    tMasterChanges;
} __TLR_PACKED_POST PROFIBUS_APM_VERIFY_DATABASE_CNF_DATA_T;

#define PROFIBUS_APM_VERIFY_DATABASE_CNF_DATA_SIZE sizeof(PROFIBUS_APM_VERIFY_DATABASE_CNF_DATA_T)

typedef __TLR_PACKED_PRE struct PROFIBUS_APM_VERIFY_DATABASE_CNF_Ttag
{
  TLR_PACKET_HEADER_T                       tHead;    /* packet header  */
  PROFIBUS_APM_VERIFY_DATABASE_CNF_DATA_T            tData;    /* packet data    */
} __TLR_PACKED_POST PROFIBUS_APM_VERIFY_DATABASE_CNF_T;

/* pragma unpack */
#ifdef PRAGMA_PACK_ENABLE
#pragma PRAGMA_UNPACK_1(PROFIBUS_APM_PUBLIC)
#endif



/***************************************************************************************/
/* Profibus Apm public, prototypes */



/***************************************************************************************/
#endif /* #ifndef __PROFIBUS_APM_PUBLIC_H */
